% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\name{covmat}
\alias{covmat}
\title{Extract a single 2 by 2 covariance matrix}
\usage{
covmat(x, i, thing = "column", axis1 = 1, axis2 = 2, show = TRUE)
}
\arguments{
\item{x}{An object of class \code{\linkS4class{cabootcrsresults}}}

\item{i}{The number of the row or column, note that in MCA this will be the number of the variable category
(e.g. for p=3 variables with 5 categories each, column 8 is the 3rd category of the 2nd variable)}

\item{thing}{Whether to extract the covariance matrix for the i-th
\describe{
\item{"row"}{row, or}
\item{"column"}{column}
}
Note that default is "column" as this is more convenient for MCA}

\item{axis1}{First axis for which (co)variances are required}

\item{axis2}{Second axis for which (co)variances are required}

\item{show}{If TRUE then print the extracted covariance matrix}
}
\value{
An object of class \code{"matrix"} (square symmetric, 2 by 2)
}
\description{
\code{covmat} extracts a 2 by 2 covariance matrix for one data point on two dimensions,
allowing the confidence ellipse to be plotted
}
\details{
This can be used with the ellipse() package to add the confidence ellipse to a picture from another package\cr

Example: confidence ellipse for row or column i on axes 1,2 from cabootcrs() output Results is:\cr

lines( ellipse(x=covmat(Results,i,"row",1,2,FALSE),
               centre=Results@Rowprinccoord[i,cbind(1,2)], npoints=1000),
       cex=1, pch=".", col="blue")\cr
lines( ellipse(x=covmat(Results,i,"column",1,2,FALSE),
               centre=Results@Colprinccoord[i,cbind(1,2)], npoints=1000),
      cex=1, pch=".", col="blue")

Note that \code{\link{reflectaxes}} will be needed if cabootcrs() and ca() axes
are reflected with respect to each other
}
\examples{
results <- cabootcrs(DreamData, showresults=FALSE)
row2covmataxes12 <- covmat(results,2,"row")
col3covmataxes23 <- covmat(results,3,"column",2,3)

\dontrun{

# There are now 3 variables with 5,4,3 categories, hence 12 columns
resultsmca <- cabootcrs(DreamData223by3, catype="mca", showresults=FALSE)
row2covmataxes12mca <- covmat(resultsmca,2,"column")
col3covmataxes23mca <- covmat(resultsmca,8,"column",2,3)
newvarcat2covmataxes12mca <- covmat(resultsmca,11,"column")


# Use ellipse() to put confidence regions around row points on a plot produced by ca().
# Note that reflectaxes() will be needed if cabootcrs() and ca() axes
# are reflected with respect to each other

library(ca)
library(ellipse)
TheData <- DreamData
Results <- cabootcrs(TheData, showresults=FALSE)
caResults <- ca(TheData)
plot(caResults)
for (i in 1:dim(TheData)[1]) {
  lines( ellipse(x=covmat(Results,i,"row",1,2,FALSE),
                 centre=Results@Rowprinccoord[i,cbind(1,2)], npoints=1000),
        cex=1, pch=".", col="blue")
}
}

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}}, \code{\link{allvarscovs}},
\code{\linkS4class{cabootcrsresults}}
}
