% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cinterp.R
\name{Cinterp}
\alias{Cinterp}
\title{Interpolation in simplexes of the objective space}
\usage{
Cinterp(param, crit, simplices, volume, n)
}
\arguments{
\item{param}{: matrix [ NPoints , NPar ] of already evaluated parameters}

\item{crit}{: matrix [ Npoints , NObj ] of associated criteria}

\item{simplices}{: matrix [ NSimp , NObj+1 ] containing all or part of the triangulation of the space of the objectives}

\item{volume}{: matrix [ NSimp , 1 ] giving the volume of each simplex (measure of the probability of interpolating in this simplex)}

\item{n}{: number of new vectors to generate}
}
\value{
xnew : matrix [ n , NPar ] of new vectors

pcrit : matrix [ n , NObj ] estimated positions of new sets in the goal space
}
\description{
proposes n new candidates by interpolation in simplexes of the objective space
}
\examples{
# Definition of the parameters
param <- matrix(rexp(100), 100, 1)
crit <- matrix(rexp(200), 100, 2)
simplices <- matrix(c(15,2,1,15,22,1,18,15,2,17,13,14), nrow = 4, ncol = 3)
volume <- runif(4)
n <- 5
# Call the function
res <- Cinterp(param, crit, simplices, volume, n)

}
\author{
Fabrice Zaoui
}
