% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRaw}
\alias{plotRaw}
\title{Plot manifest and fitted raw scores}
\usage{
plotRaw(data, model, group = NULL, raw = NULL, type = 0)
}
\arguments{
\item{data}{The raw data within a data.frame}

\item{model}{The regression model}

\item{group}{The grouping variable}

\item{raw}{The raw score variable}

\item{type}{Type of display: 0 = plot manifest against fitted values, 1 = plot
manifest against difference values}
}
\description{
The function plots the raw data against the fitted scores from
the regression model per group. This helps to inspect the precision
of the modeling process. The scores should not deviate too far from
regression line.
}
\examples{
# Load example data set, compute model and plot results
normData <- prepareData()
m <- bestModel(data = normData)
plotRaw(normData, m, group="group")
}
