% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TwoPLChoicemcmc}
\alias{TwoPLChoicemcmc}
\title{Two Parameter Choice IRT Model MCMC}
\usage{
TwoPLChoicemcmc(unique_subject_ids, subject_ids, choices_nk, fixed_effects,
  B, rv_effects_design, gamma, beta, zeta_rv, Sigma_zeta_inv, Y, theta0,
  a0, b0, mu_xi0, Sig_xi0)
}
\arguments{
\item{unique_subject_ids}{A \code{vector} with length \eqn{N \times 1}{N x 1}
containing unique subject IDs.}

\item{subject_ids}{A \code{vector} with length \eqn{NK \times 1}{N*K x 1}
containing subject IDs.}

\item{choices_nk}{A \code{vector} with length \eqn{NK \times 1}{N*K x 1}
containing subject choices.}

\item{fixed_effects}{A \code{matrix} with dimensions
\eqn{NK \times P_1}{N*K x P_1} containing
fixed effect design matrix without theta.}

\item{B}{A \eqn{V} dimensional column \code{vector}
relating \eqn{\theta_i}{theta_i} and
\eqn{\zeta_i}{zeta_i}.}

\item{rv_effects_design}{A \code{matrix} with dimensions
\eqn{NK \times V}{N*K x V} containing
random effect variables.}

\item{gamma}{A \code{vector} with dimensions \eqn{P \times 1}{P x 1}
containing fixed parameter estimates,
where \eqn{P = P_1 + P_2}}

\item{beta}{A \code{vector} with dimensions \eqn{P_2}
containing random parameter estimates.}

\item{zeta_rv}{A \code{matrix} with dimensions \eqn{N \times V}{N x V}
containing random parameter estimates.}

\item{Sigma_zeta_inv}{A \code{matrix} with dimensions
\eqn{P_2 \times P_2}{P_2 x P_2}.}

\item{Y}{A \code{matrix} of dimensions \eqn{N \times J}{N x J}
for Dichotomous item responses}

\item{theta0}{A \code{vector} of length \eqn{N \times 1}{N x 1}
for latent theta.}

\item{a0}{A \code{vector} of length \eqn{J}
for item discriminations.}

\item{b0}{A \code{vector} of length \eqn{J}
for item locations.}

\item{mu_xi0}{A \code{vector} of dimension 2 (i.e. c(0,1)) that is a
prior for item parameter means.}

\item{Sig_xi0}{A \code{matrix} of dimension 2x2 (i.e. diag(2)) that
is a prior for item parameter vc matrix.}
}
\value{
A \code{list} that contains:
\describe{
\item{\code{ai1}}{A \code{vector} of length J}
\item{\code{bi1}}{A \code{vector} of length J}
\item{\code{theta1}}{A \code{vector} of length N}
\item{\code{Z_c}}{A \code{matrix} of length NK}
\item{\code{Wzeta_0}}{A \code{matrix} of length NK}
}
}
\description{
Performs an MCMC routine for a two parameter IRT Model using Choice Data
}
\examples{
\dontrun{
# Call with the following data:
TwoPLChoicemcmc(cogDAT, theta0, a0, b0, mu_xi0, Sig_xi0)
}
}
\seealso{
\code{\link[=cIRT]{cIRT()}}, \code{\link[=rmvnorm]{rmvnorm()}}, and \code{\link[=riwishart]{riwishart()}}
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
