% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl_trips_data.R
\name{dl_trips_data}
\alias{dl_trips_data}
\title{Download historical bike trips data in Norway}
\usage{
dl_trips_data(year, month, city)
}
\arguments{
\item{year}{A numeric variable that informs the function for which year you want to
download data.}

\item{month}{A numeric variable that informs the function for which year you want to
download data.}

\item{city}{A character string that informs the function for which city you want to
download data from.}
}
\value{
The function downloads a CSV-file to your current working directory.
}
\description{
\code{dl_trips_data} downloads anonymized historical bike trip records in
Norway for the city of Oslo, Bergen, and Trondheim.

To get trip records for winter bikes in each city, add a capital "W" at
the end of the city name (f.ex. "OsloW" for Oslo). Trip records for winter
bikes are currently only available for Oslo at the time of writing
(2019-03-04).

The data is provided according to the Norwegian License for Open Government
Data 2.0 \href{https://data.norge.no/nlod/en/2.0}{NLOD 2.0}.
}
\examples{
\dontrun{

# Download bike trips data for the month of January, 2019, in Bergen
dl_trips_data(2019, 01, "Bergen")

# Download bike trips data for the month of October, 2018, in Trondheim
dl_trips_data(2018, 10, "Trondheim")

# Use "lapply()" to download bike trips data for several months in Oslo
lapply(06:12, dl_trips_data, year = 2018, city = "Oslo")

}

}
