\name{threshold_image_list}
\alias{threshold_image_list}
\title{
Image to matrix - List
}
\description{
Convert two or more images into a list of matrices
}
\usage{
threshold_image_list(list_names, filetype = "jpeg", compress_method = "none", 
compress_rate = 1, target_width = 100, target_height = 100, 
black_regulation = 0.5, transparency_regulation = 0.5)
}
\arguments{
  \item{list_names}{
An object contains the names of the files.
}
  \item{filetype}{
Type of the file to be load. Compatible file types: ".JPGE", ".JPG" or ".PNG".
}
  \item{compress_method}{
For high resolution files, i.e. numbers of pixels in width and height, it is suggested to reduce the resolution to create a smaller matrix, it strongly reduce GPU usage and time necessary to run analyses. On the other hand, by reducing resolution, it will also reduce the accuracy of data description. Methods for image compression: (i) frame_fixed: compress images to a desired target width and height; (ii) proportional:  compress the image by a given ratio provide in the argument "proportion"; (iii) width_fixed: compress images to get a target width. The image height will also be reduced, in the same intensity. For instance, if the original file had 1000 pixel in width, and width_fixed was set to 100, the height reduction will reduce in a rate of 0.1 (100/1000) ; (iv) height_fixed: analogous to width_fixed, but assumes height as reference.
}
  \item{compress_rate}{
Compress rate to by apply if compress_method=proportional. Note:  it should be ser as number range from 0 to 1 .
}
  \item{target_width}{
Target width to be used if compress_method=frame_fixed or compress_method= width_fixed.
}
  \item{target_height}{
Target height to be used if compress_method=frame_fixed or compress_method= height_fixed.
}
  \item{black_regulation}{
For each pixel, the intensity of red, green and blue is averaged and compared to a black_regulation (threshold). If the average intensity is less than the black_regulation (default is 0.5) the pixel will be set as black, otherwise it will be white.
}
  \item{transparency_regulation}{
For PNG images, the alpha channel is used to set transparent pixels, i.e. alpha channel values above transparency_regulation (a threshold) will set the pixel as transparent, default is 0.5.  NOTE: In the data matrix the value 1 represents black pixels, 0 represents white pixels and NA represents transparent pixels.
}
}

\value{
A matrix of 0, 1 and NA representing white, black and transparent pixels, respectively.
}

\author{
Carlos Biagolini-Jr.
}


\seealso{
threshold_color
}
\examples{
# Image examples provided by bwimage package
bush<-system.file("extdata/bush.JPG",package ="bwimage")
canopy<-system.file("extdata/canopy.JPG",package ="bwimage")

# Convert images to a list of matrices
working_matrices<-threshold_image_list(c(bush,canopy), "jpeg", "proportional", compress_rate = 0.1)
}