% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{compute_dic}
\alias{compute_dic}
\alias{compute_dic.bvarmn}
\title{Deviance Information Criterion of Multivariate Time Series Model}
\usage{
compute_dic(object, ...)

\method{compute_dic}{bvarmn}(object, n_iter = 100L, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}

\item{n_iter}{Number to sample}
}
\value{
DIC value.
}
\description{
Compute DIC of BVAR and BVHAR.
}
\details{
Deviance information criteria (DIC) is

\deqn{- 2 \log p(y \mid \hat\theta_{bayes}) + 2 p_{DIC}}

where \eqn{p_{DIC}} is the effective number of parameters defined by

\deqn{p_{DIC} = 2 ( \log p(y \mid \hat\theta_{bayes}) - E_{post} \log p(y \mid \theta) )}

Random sampling from posterior distribution gives its computation, \eqn{\theta_i \sim \theta \mid y, i = 1, \ldots, M}

\deqn{p_{DIC}^{computed} = 2 ( \log p(y \mid \hat\theta_{bayes}) - \frac{1}{M} \sum_i \log p(y \mid \theta_i) )}
}
\references{
Gelman, A., Carlin, J. B., Stern, H. S., & Rubin, D. B. (2013). \emph{Bayesian data analysis}. Chapman and Hall/CRC.

Spiegelhalter, D.J., Best, N.G., Carlin, B.P. and Van Der Linde, A. (2002). \emph{Bayesian measures of model complexity and fit}. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 64: 583-639.
}
