% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_demograph}
\alias{plot_demograph}
\title{Create an ggplot2 object for plotting fhx demographics.}
\usage{
plot_demograph(x, color_group, color_id, facet_group, facet_id,
  facet_type = "grid", ylabels = TRUE, yearlims = FALSE,
  composite_rug = FALSE, filter_prop = 0.25, filter_min = 2,
  injury_event = FALSE, plot_legend = FALSE, event_size = c(Scar = 4,
  Injury = 2, `Pith/Bark` = 1.5), rugbuffer_size = 2, rugdivide_pos = 2)
}
\arguments{
\item{x}{An \code{fhx} instance.}

\item{color_group}{Option to plot series with colors. This is a character vector or factor which corresponds to the series names given in \code{color_id}. Both \code{color_group} and \code{color_id} need to be specified. Default plot gives no color.}

\item{color_id}{Option to plot series with colors. A character vector of series names corresponding to groups given in \code{color_group}. Every unique value in \code{x} series.names needs to have a corresponding color_group value. Both \code{color_group} and \code{color_id} need to be specified. Default plot gives no species colors.}

\item{facet_group}{Option to plot series with faceted by a factor. A vector of factors or character vector which corresponds to the series names given in \code{facet_id}. Both \code{facet_group} and \code{facet_id} need to be specified. Default plot is not faceted.}

\item{facet_id}{Option to plot series with faceted by a factor. A vector of series names corresponding to species names given in \code{facet_group}. Every unique values in \code{x} series.names needs to have a corresponding facet_group value. Both \code{facet_group} and \code{facet_id} need to be specified.  Default plot is not faceted. Note that composite_rug and facet_group, facet_id cannot be used in the same plot. You must choose facets or a composite rug.}

\item{facet_type}{Type of \code{ggplot2} facet to use, if faceting. Must be either "grid" or "wrap". Default is "grid". Note that composite_rug and facet_group, facet_id cannot be used in the same plot. You must choose facets or a composite rug.}

\item{ylabels}{Optional boolean to remove y-axis (series name) labels and tick  marks. Default is TRUE.}

\item{yearlims}{Option to limit the plot to a range of years. This is a vector with two integers. The first integer gives the lower year for the range while the second integer gives the upper year. The default is to plot the full range of data given by \code{x}.}

\item{composite_rug}{A boolean option to plot a rug on the bottom of the plot. Default is FALSE. Note that composite_rug and facet_group, facet_id cannot be used in the same plot. You must choose facets or a composite rug.}

\item{filter_prop}{An optional argument if the user chooses to include a composite rug in their plot. This is passed to \code{composite}. See this function for details.}

\item{filter_min}{An optional argument if the user chooses to include a composite rug in their plot. This is passed to \code{composite}. See this function for details.}

\item{injury_event}{Boolean indicating whether injuries should be considered recorders. This is passed to \code{composite}. See this function for details.}

\item{plot_legend}{A boolean option allowing the user to choose whether a legend is included in the plot or not. Default is FALSE.}

\item{event_size}{An optional numeric vector that adjusts the size of fire event symbols on the plot. Default is \code{c("Scar" = 4, "Injury" = 2, "Pith/Bark" = 1.5)}.}

\item{rugbuffer_size}{An optional integer. If the user plots a rug, thiscontrols the amount of buffer whitespace along the y-axis between the rug and the main plot. Must be >= 2.}

\item{rugdivide_pos}{Optional integer if plotting a rug. Adjust the placement of the rug divider along the y-axis. Default is 2.}
}
\value{
A ggplot object for plotting or manipulation.
}
\description{
Create an ggplot2 object for plotting fhx demographics.
}
\examples{
data(lgr2)
plot(lgr2)

plot(lgr2, ylabels = FALSE, plot_legend = TRUE)

data(lgr2_meta)
# With color showing species.
plot(lgr2,
     color_group = lgr2_meta$SpeciesID,
     color_id = lgr2_meta$TreeID,
     plot_legend = TRUE)
# With facets for each species.
plot(lgr2,
     facet_group = lgr2_meta$SpeciesID,
     facet_id = lgr2_meta$TreeID,
     plot_legend = TRUE)

# Append annotation onto a ggplot object.
require(ggplot2)
p <- plot_demograph(lgr2,
                color_group = lgr2_meta$SpeciesID,
                color_id = lgr2_meta$TreeID)
# Add transparent box as annotation to plot.
p + annotate('rect',
             xmin = 1750, xmax = 1805,
             ymin = 3.5, ymax = 13.5, alpha = 0.2)

}

