% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_ausbildungssuche.R
\name{ausbildungssuche_search}
\alias{ausbildungssuche_search}
\title{Search training offers}
\usage{
ausbildungssuche_search(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with training offers.

Includes \code{aktualisierungsdatum_time} as POSIXct in Europe/Berlin.
}
\description{
Search training offers
}
\details{
The Ausbildungssuche API provides training offer data from the
Bundesagentur fuer Arbeit. Authentication is required via \code{X-API-Key}
(clientId \code{infosysbub-absuche}, discoverable from
https://web.arbeitsagentur.de/weiterbildungssuche/suche). Official docs:
https://bundesapi.github.io/ausbildungssuche-api/.

This adapter uses the \code{X-API-Key} header. Set it via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} and
\code{AUSBILDUNGSSUCHE_API_KEY}.
}
\examples{
\dontrun{
Sys.setenv(AUSBILDUNGSSUCHE_API_KEY = "infosysbub-absuche")
bunddev_auth_set("ausbildungssuche", type = "api_key", env_var = "AUSBILDUNGSSUCHE_API_KEY")
ausbildungssuche_search(params = list(size = 5))
}

}
\seealso{
\code{\link[=ausbildungssuche_details]{ausbildungssuche_details()}} for a single offer and \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} for
authentication.
}
