% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{build.formula}
\alias{build.formula}
\title{Convert a buildmer term list into a proper model formula}
\usage{
build.formula(dep, terms, env = parent.frame())
}
\arguments{
\item{dep}{The dependent variable.}

\item{terms}{The term list.}

\item{env}{The environment of the formula to return.}
}
\value{
A formula.
}
\description{
Convert a buildmer term list into a proper model formula
}
\examples{
library(buildmer)
form1 <- Reaction ~ Days + (Days|Subject)
terms <- tabulate.formula(form1)
form2 <- build.formula(dep='Reaction',terms)

# check that the two formulas give the same results
library(lme4)
check <- function (f) resid(lmer(f,sleepstudy))
all.equal(check(form1),check(form2))

# can also do double bars now
form1 <- Reaction ~ Days + (Days||Subject)
terms <- tabulate.formula(form1)
form2 <- build.formula(dep='Reaction',terms)
all.equal(check(form1),check(form2))
}
