% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-search-packages.R
\name{btw_tool_search_packages}
\alias{btw_tool_search_packages}
\title{Tool: Search for an R package on CRAN}
\usage{
btw_tool_search_packages(
  query,
  format = c("short", "long"),
  n_results = NULL,
  `_intent` = ""
)
}
\arguments{
\item{query}{Search query string. If this argument is missing or
\code{NULL}, then the results of the last query are printed, in
\emph{short} and \emph{long} formats, in turns for successive
\code{pkg_search()} calls. If this argument is missing, then all
other arguments are ignored.}

\item{format}{Default formatting of the results. \emph{short} only
outputs the name and title of the packages, \emph{long} also
prints the author, last version, full description and URLs.
Note that this only affects the default printing, and you can
still inspect the full results, even if you specify \emph{short}
here.}

\item{n_results}{Number of search results to include. Defaults to 10 for
'short' format and 5 for 'long' format.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A listing of packages matching the search term.
}
\description{
Uses \code{\link[pkgsearch:pkg_search]{pkgsearch::pkg_search()}} to search for R packages on CRAN.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
# Copy pkgsearch results to the clipboard for use in any LLM app
btw(
  pkgsearch::pkg_search("network visualization", size = 1),
  clipboard = FALSE
)
btw(
  pkgsearch::pkg_search("network visualization", format = "long", size = 1),
  clipboard = FALSE
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
