% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btw_client.R, R/btw_client_app.R
\name{btw_client}
\alias{btw_client}
\alias{btw_app}
\title{Create a btw-enhanced ellmer chat client}
\usage{
btw_client(
  ...,
  client = NULL,
  tools = NULL,
  path_btw = NULL,
  path_llms_txt = NULL
)

btw_app(..., client = NULL, tools = NULL, path_btw = NULL, messages = list())
}
\arguments{
\item{...}{In \code{btw_app()}, additional arguments are passed to
\code{\link[shiny:shinyApp]{shiny::shinyApp()}}. In \code{btw_client()}, additional arguments are ignored.}

\item{client}{An \link[ellmer:Chat]{ellmer::Chat} client or a \code{provider/model} string to be
passed to \code{\link[ellmer:chat-any]{ellmer::chat()}} to create a chat client. Defaults to
\code{\link[ellmer:chat_anthropic]{ellmer::chat_anthropic()}}. You can use the \code{btw.client} option to set a
default client for new \code{btw_client()} calls, or use a \code{btw.md} project file
for default chat client settings, like provider and model. We check the
\code{client} argument, then the \code{btw.client} R option, and finally the \code{btw.md}
project file (falling back to user-level \code{btw.md} if needed), using only the
client definition from the first of these that is available.}

\item{tools}{A list of tools to include in the chat, defaults to
\code{\link[=btw_tools]{btw_tools()}}. Join \code{\link[=btw_tools]{btw_tools()}} with additional tools defined by
\code{\link[ellmer:tool]{ellmer::tool()}} to include additional tools in the chat client.
Alternatively, you can use a character values to refer to specific btw
tools by name or by group. For example, use \code{tools = "docs"} to include
only the documentation related tools, or \code{tools = c("env", "docs")} to
include the environment and documentation tools, and so on. You can also
refer to btw tools by name, e.g. \code{tools = "btw_tool_docs_help_page"} or
alternatively in the shorter form \code{tools = "docs_help_page"}. Finally,
set \code{tools = FALSE} to skip registering \pkg{btw} tools with the chat
client.}

\item{path_btw}{A path to a \code{btw.md} or \code{AGENTS.md} project context file. If
\code{NULL}, btw will find a project-specific \code{btw.md} or \code{AGENTS.md} file in
the parents of the current working directory, with fallback to user-level
\code{btw.md} if no project file is found. Set \code{path_btw = FALSE} to
create a chat client without using a \code{btw.md} file.}

\item{path_llms_txt}{A path to an \code{llms.txt} file containing context about
the current project. By default, btw will look for an \code{llms.txt} file in
the your current working directory or its parents. Set \code{path_llms_txt = FALSE} to skip looking for an \code{llms.txt} file.}

\item{messages}{A list of initial messages to show in the chat, passed to
\code{\link[shinychat:chat_app]{shinychat::chat_mod_ui()}}.}
}
\value{
Returns an \link[ellmer:Chat]{ellmer::Chat} object with additional tools registered
from \code{\link[=btw_tools]{btw_tools()}}. \code{btw_app()} returns the chat object invisibly, and
the chat object with the messages added during the chat session.
}
\description{
Creates an \link[ellmer:Chat]{ellmer::Chat} client, enhanced with the tools from
\code{\link[=btw_tools]{btw_tools()}}. Use \code{btw_client()} to create the chat client for
general or interactive use at the console, or \code{btw_app()} to create a chat
client and launch a Shiny app for chatting with a btw-enhanced LLM in your
local workspace.
\subsection{Project Context}{

You can keep track of project-specific rules, guidance and context by adding
a \code{btw.md} file or \href{https://agents.md/}{\code{AGENTS.md}} in your project
directory. See \code{\link[=use_btw_md]{use_btw_md()}} for help creating a \code{btw.md} file in your
project, or use \code{path_btw} to tell \code{btw_client()} to use a specific context
file.

\code{btw_client()} will also include context from an \code{llms.txt} file in the
system prompt, if one is found in your project directory or as specified by
the \code{path_llms_txt} argument.
}

\subsection{Client Settings with User-Level Fallback}{

Client settings in \code{client} and \code{tools} from a project-level \code{btw.md} or
\code{AGENTS.md} file take precedence. If a project file doesn't specify a
setting, btw will fall back to settings in a user-level \code{btw.md} file
(typically in \verb{~/btw.md} or \verb{~/.config/btw/btw.md}). Project-level btw tool
options under the \code{options} key are merged with user-level options, with
project-level options taking precedence.

Project-specific instructions from both files are combined with a divider,
allowing you to maintain global guidelines in your user file and
project-specific rules in your project file.
}

\subsection{Client Options}{

The following R options are consulted when creating a new btw chat client and
take precedence over settings in a \code{btw.md} file:
\itemize{
\item \code{btw.client}: The \link[ellmer:Chat]{ellmer::Chat} client or a \code{provider/model} string (see
\code{\link[ellmer:chat-any]{ellmer::chat()}}) to use as the basis for new \code{btw_client()} or
\code{btw_app()} chats.
\item \code{btw.tools}: The btw tools to include by default when starting a new
btw chat, see \code{\link[=btw_tools]{btw_tools()}} for details.`
}
}
}
\section{Functions}{
\itemize{
\item \code{btw_client()}: Create a btw-enhanced \link[ellmer:Chat]{ellmer::Chat} client

\item \code{btw_app()}: Create a btw-enhanced client and launch a Shiny app to
chat

}}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
withr::local_options(list(
  btw.client = ellmer::chat_ollama(model="llama3.1:8b")
))

chat <- btw_client()
chat$chat(
  "How can I replace `stop()` calls with functions from the cli package?"
)
\dontshow{\}) # examplesIf}
}
