% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptotic_var.R
\name{iact}
\alias{iact}
\title{Integrated Autocorrelation Time}
\usage{
iact(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A single numeric value of IACT estimate.
}
\description{
Estimates the integrated autocorrelation time (IACT) based on Sokal (1997).
Note that the estimator is not particularly good for very short series x
(say < 100), but that is not very practical for MCMC applications anyway.
}
\examples{
set.seed(1)
n <- 1000
x <- numeric(n)
phi <- 0.8
for(t in 2:n) x[t] <- phi * x[t-1] + rnorm(1)
iact(x)
}
\references{
Sokal A. (1997) Monte Carlo Methods in Statistical Mechanics: Foundations
and New Algorithms.
In: DeWitt-Morette C., Cartier P., Folacci A. (eds) Functional Integration.
NATO ASI Series (Series B: Physics), vol 361. Springer, Boston, MA.
https://doi.org/10.1007/978-1-4899-0319-8_6
}
