% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_bscui_element.R
\name{add_bscui_element}
\alias{add_bscui_element}
\title{Add an SVG element to the UI}
\usage{
add_bscui_element(proxy, id, svg_txt, ui_type = NULL, title = NULL)
}
\arguments{
\item{proxy}{a \code{\link{bscui_Proxy}} object}

\item{id}{the identifier of the element to add (will replace the id
attribute of the provided svg if any)}

\item{svg_txt}{a character with SVG code of one element and its children}

\item{ui_type}{either "selectable", "button" or "none". If NULL (default),
the element won't be available as UI}

\item{title}{a description of the element to display on mouseover event}
}
\value{
the provided proxy object
}
\description{
Add an SVG element to the UI
}
\examples{
if(interactive()){
   from_shiny <- new.env()
   shiny::runApp(system.file(
      "examples", "shiny-anatomogram", package = "bscui"
   ))
   for(n in names(from_shiny)){
      bscui(from_shiny[[n]]) |> print()
   }
}
}
