% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{userPost}
\alias{userPost}
\title{AdminLTE3 user post}
\usage{
userPost(..., id = NULL, src = NULL, author = NULL,
  description = NULL, collapsible = TRUE, collapsed = FALSE,
  collapse_status = NULL)
}
\arguments{
\item{...}{Post content, slot for \link{userPostTagItems}, \link{userPostMedia}.}

\item{id}{Unique id of the post.}

\item{src}{Profile image, if any.}

\item{author}{Post author.}

\item{description}{Post description.}

\item{collapsible}{If TRUE, display a button in the upper right that allows the user to collapse the comment.}

\item{collapsed}{Whether the comment is collapsed when the application starts, FALSE by default.}

\item{collapse_status}{Color of the collapse button. NULL by default but also "primary", "info",
"danger", "warning", "success", "secondary" ...}
}
\description{
Create a user post
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    bs4DashNavbar(),
    bs4DashSidebar(),
    bs4DashControlbar(),
    bs4DashBody(
     bs4Card(
      title = "Box with user comment",
      status = "primary",
      userPost(
       id = 1,
       src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
       author = "Jonathan Burke Jr.",
       description = "Shared publicly - 7:30 PM today",
       "Lorem ipsum represents a long-held tradition for designers, 
       typographers and the like. Some people hate it and argue for 
       its demise, but others ignore the hate as they create awesome 
       tools to help create filler text for everyone from bacon 
       lovers to Charlie Sheen fans.",
       userPostTagItems(
        userPostTagItem(bs4Badge("item 1", status = "warning")),
        userPostTagItem(bs4Badge("item 2", status = "danger"))
       )
      ),
      userPost(
       id = 2,
       src = "https://adminlte.io/themes/AdminLTE/dist/img/user6-128x128.jpg",
       author = "Adam Jones",
       description = "Shared publicly - 5 days ago",
       userPostMedia(src = "https://adminlte.io/themes/AdminLTE/dist/img/photo2.png"),
       userPostTagItems(
        userPostTagItem(bs4Badge("item 1", status = "info")),
        userPostTagItem(bs4Badge("item 2", status = "danger"))
       )
      )
     )
    ),
    title = "userPost"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
