% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_01_basic.R
\name{p}
\alias{p}
\alias{p.z}
\alias{p.t}
\alias{p.f}
\alias{p.r}
\alias{p.chi2}
\title{Compute \emph{p} value.}
\usage{
p(
  z = NULL,
  t = NULL,
  f = NULL,
  r = NULL,
  chi2 = NULL,
  n = NULL,
  df = NULL,
  df1 = NULL,
  df2 = NULL,
  nsmall = 2
)

p.z(z)

p.t(t, df)

p.f(f, df1, df2)

p.r(r, n)

p.chi2(chi2, df)
}
\arguments{
\item{z, t, f, r, chi2}{\emph{z}, \emph{t}, \emph{F}, \emph{r}, \eqn{\chi}^2 value.}

\item{n, df, df1, df2}{Sample size or degree of freedom.}

\item{nsmall}{Number of decimal places of output. Default is \code{2}.}
}
\value{
\emph{p} value statistics.
}
\description{
Compute \emph{p} value.
}
\section{Functions}{
\itemize{
\item \code{p.z}: Two-tailed \emph{p} value of \emph{z}.

\item \code{p.t}: Two-tailed \emph{p} value of \emph{t}.

\item \code{p.f}: One-tailed \emph{p} value of \emph{F}. (Note: \emph{F} test is one-tailed only.)

\item \code{p.r}: Two-tailed \emph{p} value of \emph{r}.

\item \code{p.chi2}: One-tailed \emph{p} value of \eqn{\chi}^2. (Note: \eqn{\chi}^2 test is one-tailed only.)
}}

\examples{
p.z(1.96)
p.t(2, 100)
p.f(4, 1, 100)
p.r(0.2, 100)
p.chi2(3.84, 1)

p(z=1.96)
p(t=2, df=100)
p(f=4, df1=1, df2=100)
p(r=0.2, n=100)
p(chi2=3.84, df=1)

}
