% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_tidiers.R
\name{summary_tidiers}
\alias{glance.summaryDefault}
\alias{summary_tidiers}
\alias{tidy.summaryDefault}
\title{Tidiers for summaryDefault objects}
\usage{
\method{tidy}{summaryDefault}(x, ...)

\method{glance}{summaryDefault}(x, ...)
}
\arguments{
\item{x}{summaryDefault object}

\item{...}{extra arguments, not used}
}
\value{
Both \code{tidy} and \code{glance} return the same object:
a one-row data frame with columns
  \item{minimum}{smallest value in original vector}
  \item{q1}{value at the first quartile}
  \item{median}{median of original vector}
  \item{mean}{mean of original vector}
  \item{q3}{value at the third quartile}
  \item{maximum}{largest value in original vector}
  \item{NAs}{number of NA values (if any)}
}
\description{
Tidy a summary of a vector.
}
\examples{

v <- rnorm(1000)
s <- summary(v)
s

tidy(s)
glance(s)

v2 <- c(v,NA)
tidy(summary(v2))

}
\seealso{
\code{\link{summary}}
}

