% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{bootstrap}
\alias{bootstrap}
\title{Set up bootstrap replicates of a dplyr operation}
\usage{
bootstrap(df, m, by_group = FALSE)
}
\arguments{
\item{df}{a data frame}

\item{m}{number of bootstrap replicates to perform}

\item{by_group}{If \code{TRUE}, then bootstrap within each group if \code{df} is
a grouped tbl.}
}
\description{
Set up bootstrap replicates of a dplyr operation
}
\details{
This code originates from Hadley Wickham (with a few small
corrections) here:

https://github.com/hadley/dplyr/issues/269

Some examples can be found at

https://github.com/dgrtwo/broom/blob/master/vignettes/bootstrapping.Rmd
}
\examples{

library(dplyr)
mtcars \%>\% bootstrap(10) \%>\% do(tidy(lm(mpg ~ wt, .)))

}

