% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/optim_tidiers.R
\name{optim_tidiers}
\alias{glance_optim}
\alias{optim_tidiers}
\alias{tidy_optim}
\title{Tidiers for lists returned from optim}
\usage{
tidy_optim(x, ...)

glance_optim(x, ...)
}
\arguments{
\item{x}{list returned from \code{optim}}

\item{...}{extra arguments}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns a data frame with one row per parameter that
was estimated, with columns
  \item{parameter}{name of the parameter, or \code{parameter1},
  \code{parameter2}... if the input vector is not named}
  \item{value}{parameter value that minimizes or maximizes the output}

\code{glance} returns a one-row data frame with the columns
  \item{value}{minimized or maximized output value}
  \item{function.count}{number of calls to \code{fn}}
  \item{gradient.count}{number of calls to \code{gr}}
  \item{convergence}{convergence code representing the error state}
}
\description{
Tidies objects returned by the \code{\link{optim}} function for
general-purpose minimization and maximization.
}
\examples{
func <- function(x) {
    (x[1] - 2)^2 + (x[2] - 3)^2 + (x[3] - 8)^2
}

o <- optim(c(1, 1, 1), func)

tidy(o)
glance(o)
}
\seealso{
\code{\link{optim}}
}

