% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_terms.R
\name{model_get_terms}
\alias{model_get_terms}
\alias{model_get_terms.default}
\alias{model_get_terms.brmsfit}
\title{Get the terms of a model}
\usage{
model_get_terms(model)

\method{model_get_terms}{default}(model)

\method{model_get_terms}{brmsfit}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
Return the result of \code{\link[stats:terms]{stats::terms()}} applied to the model
or \code{NULL} if it is not possible to get terms from \code{model}.
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) \%>\%
  model_get_terms()
}
\seealso{
\code{\link[stats:terms]{stats::terms()}}

Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
