% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndim.R
\name{ndim}
\alias{ndim}
\alias{lst.ndim}
\title{Get the Number of Dimensions of an Array}
\usage{
ndim(x)

lst.ndim(x)
}
\arguments{
\item{x}{a vector or array (for \code{ndim()}), or a list of vectors/arrays (for \code{lst.ndim()}). \cr}
}
\value{
For \code{ndim()}: an integer scalar. \cr
For \code{lst.ndim()}: an integer vector, with the same length, names and dimensions as \code{x}. \cr
}
\description{
\code{ndim()} returns the number of dimensions of an object. \cr
\code{lst.ndim()} returns the number of dimensions of every list-element. \cr
\cr
}
\examples{

x <- array(1:24, 2:4)
ndim(x)

x <- list(
  array(1:10, 10),
  array(1:10, c(2, 5)),
  array(c(letters, NA), c(3,3,3))
)
lst.ndim(x)

x <- list(
  1:10,
  array(1:10, 10),
  matrix(1:10, 2, 5),
  array(c(letters, NA), c(3,3,3))
)
dim(x) <- c(2,2)
dimnames(x) <- list(c("a", "b"), c("x", "y"))
lst.ndim(x)


}
