% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_multiple.R
\name{brm_multiple}
\alias{brm_multiple}
\title{Run the same \pkg{brms} model on multiple datasets}
\usage{
brm_multiple(
  formula,
  data,
  family = gaussian(),
  prior = NULL,
  data2 = NULL,
  autocor = NULL,
  cov_ranef = NULL,
  sample_prior = c("no", "yes", "only"),
  sparse = NULL,
  knots = NULL,
  stanvars = NULL,
  stan_funs = NULL,
  silent = 1,
  recompile = FALSE,
  combine = TRUE,
  fit = NA,
  seed = NA,
  file = NULL,
  file_refit = "never",
  ...
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link{brmsformula}}.}

\item{data}{A \emph{list} of data.frames each of which will be used to fit a
separate model. Alternatively, a \code{mids} object from the \pkg{mice}
package.}

\item{family}{A description of the response distribution and link function to
be used in the model. This can be a family function, a call to a family
function or a character string naming the family. Every family function has
a \code{link} argument allowing to specify the link function to be applied
on the response variable. If not specified, default links are used. For
details of supported families see \code{\link{brmsfamily}}. By default, a
linear \code{gaussian} model is applied. In multivariate models,
\code{family} might also be a list of families.}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link{set_prior}} or related functions and combined using the
\code{c} method or the \code{+} operator. See also  \code{\link{get_prior}}
for more help.}

\item{data2}{A \emph{list} of named lists each of which will be used to fit a
separate model. Each of the named lists contains objects representing data
which cannot be passed via argument \code{data} (see \code{\link{brm}} for
examples). The length of the outer list should match the length of the list
passed to the \code{data} argument.}

\item{autocor}{(Deprecated) An optional \code{\link{cor_brms}} object
describing the correlation structure within the response variable (i.e.,
the 'autocorrelation'). See the documentation of \code{\link{cor_brms}} for
a description of the available correlation structures. Defaults to
\code{NULL}, corresponding to no correlations. In multivariate models,
\code{autocor} might also be a list of autocorrelation structures.
It is now recommend to specify autocorrelation terms directly
within \code{formula}. See \code{\link{brmsformula}} for more details.}

\item{cov_ranef}{(Deprecated) A list of matrices that are proportional to the
(within) covariance structure of the group-level effects. The names of the
matrices should correspond to columns in \code{data} that are used as
grouping factors. All levels of the grouping factor should appear as
rownames of the corresponding matrix. This argument can be used, among
others to model pedigrees and phylogenetic effects. 
It is now recommended to specify those matrices in the formula
interface using the \code{\link{gr}} and related functions. See
\code{vignette("brms_phylogenetics")} for more details.}

\item{sample_prior}{Indicate if samples from priors should be drawn
additionally to the posterior samples. Options are \code{"no"} (the
default), \code{"yes"}, and \code{"only"}. Among others, these samples can
be used to calculate Bayes factors for point hypotheses via
\code{\link{hypothesis}}. Please note that improper priors are not sampled,
including the default improper priors used by \code{brm}. See
\code{\link{set_prior}} on how to set (proper) priors. Please also note
that prior samples for the overall intercept are not obtained by default
for technical reasons. See \code{\link{brmsformula}} how to obtain prior
samples for the intercept. If \code{sample_prior} is set to \code{"only"},
samples are drawn solely from the priors ignoring the likelihood, which
allows among others to generate samples from the prior predictive
distribution. In this case, all parameters must have proper priors.}

\item{sparse}{(Deprecated) Logical; indicates whether the population-level
design matrices should be treated as sparse (defaults to \code{FALSE}). For
design matrices with many zeros, this can considerably reduce required
memory. Sampling speed is currently not improved or even slightly
decreased. It is now recommended to use the \code{sparse} argument of
\code{\link{brmsformula}} and related functions.}

\item{knots}{Optional list containing user specified knot values to be used
for basis construction of smoothing terms. See
\code{\link[mgcv:gamm]{gamm}} for more details.}

\item{stanvars}{An optional \code{stanvars} object generated by function
\code{\link{stanvar}} to define additional variables for use in
\pkg{Stan}'s program blocks.}

\item{stan_funs}{(Deprecated) An optional character string containing
self-defined  \pkg{Stan} functions, which will be included in the functions
block of the generated \pkg{Stan} code. It is now recommended to use the
\code{stanvars} argument for this purpose instead.}

\item{silent}{Verbosity level between \code{0} and \code{2}.
If \code{1} (the default), most of the
informational messages of compiler and sampler are suppressed.
If \code{2}, even more messages are suppressed. The actual
sampling progress is still printed. Set \code{refresh = 0} to turn this off
as well. If using \code{backend = "rstan"} you can also set
\code{open_progress = FALSE} to prevent opening additional progress bars.}

\item{recompile}{Logical, indicating whether the Stan model should be
recompiled for every imputed data set. Defaults to \code{FALSE}. If
\code{NULL}, \code{brm_multiple} tries to figure out internally, if recompilation
is necessary, for example because data-dependent priors have changed.
Using the default of no recompilation should be fine in most cases.}

\item{combine}{Logical; Indicates if the fitted models should be combined
into a single fitted model object via \code{\link{combine_models}}.
Defaults to \code{TRUE}.}

\item{fit}{An instance of S3 class \code{brmsfit_multiple} derived from a
previous fit; defaults to \code{NA}. If \code{fit} is of class
\code{brmsfit_multiple}, the compiled model associated with the fitted
result is re-used and all arguments modifying the model code or data are
ignored. It is not recommended to use this argument directly, but to call
the \code{\link[brms:update.brmsfit_multiple]{update}} method, instead.}

\item{seed}{The seed for random number generation to make results
reproducible. If \code{NA} (the default), \pkg{Stan} will set the seed
randomly.}

\item{file}{Either \code{NULL} or a character string. In the latter case, the
fitted model object is saved via \code{\link{saveRDS}} in a file named
after the string supplied in \code{file}. The \code{.rds} extension is
added automatically. If the file already exists, \code{brm} will load and
return the saved model object instead of refitting the model. 
Unless you specify the \code{file_refit} argument as well, the existing
files won't be overwritten, you have to manually remove the file in order
to refit and save the model under an existing file name. The file name
is stored in the \code{brmsfit} object for later usage.}

\item{file_refit}{Modifies when the fit stored via the \code{file} parameter
is re-used. For \code{"never"} (default) the fit is always loaded if it
exists and fitting is skipped. If set to \code{"on_change"}, brms will
refit the model if model, data or algorithm as passed to Stan differ from
what is stored in the file. This also covers changes in priors,
\code{sample_prior}, \code{stanvars}, covariance structure, etc. If you
believe there was a false positive, you can use
\code{\link{brmsfit_needs_refit}} to see why refit is deemed necessary.
Refit will not be triggered for changes in additional parameters of the fit
(e.g., initial values, number of iterations, control arguments, ...). A
known limitation is that a refit will be triggered if within-chain
parallelization is switched on/off.}

\item{...}{Further arguments passed to \code{\link{brm}}.}
}
\value{
If \code{combine = TRUE} a \code{brmsfit_multiple} object, which
  inherits from class \code{brmsfit} and behaves essentially the same. If
  \code{combine = FALSE} a list of \code{brmsfit} objects.
}
\description{
Run the same \pkg{brms} model on multiple datasets and then combine the
results into one fitted model object. This is useful in particular for
multiple missing value imputation, where the same model is fitted on multiple
imputed data sets. Models can be run in parallel using the \pkg{future}
package.
}
\details{
The combined model may issue false positive convergence warnings, as
  the MCMC chains corresponding to different datasets may not necessarily
  overlap, even if each of the original models did converge. To find out
  whether each of the original models converged, investigate
  \code{fit$rhats}, where \code{fit} denotes the output of
  \code{brm_multiple}.
}
\examples{
\dontrun{
library(mice)
imp <- mice(nhanes2)

# fit the model using mice and lm
fit_imp1 <- with(lm(bmi ~ age + hyp + chl), data = imp)
summary(pool(fit_imp1))

# fit the model using brms
fit_imp2 <- brm_multiple(bmi ~ age + hyp + chl, data = imp, chains = 1)
summary(fit_imp2)
plot(fit_imp2, pars = "^b_")
# investigate convergence of the original models
fit_imp2$rhats

# use the future package for parallelization
library(future)
plan(multiprocess)
fit_imp3 <- brm_multiple(bmi~age+hyp+chl, data = imp, chains = 1)
summary(fit_imp3)
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
