% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{cor_arma}
\alias{cor.arma}
\alias{cor_arma}
\title{ARMA(p,q) correlation structure}
\usage{
cor_arma(formula = ~1, p = 0, q = 0, r = 0, cov = FALSE)
}
\arguments{
\item{formula}{A one sided formula of the form ~ t, or ~ t | g, 
specifying a time covariate t and, optionally, a grouping factor g. 
A covariate for this correlation structure must be integer valued. 
When a grouping factor is present in \code{formula}, the correlation structure 
is assumed to apply only to observations within the same grouping level; 
observations with different grouping levels are assumed to be uncorrelated. 
Defaults to ~ 1, which corresponds to using the order of the observations 
in the data as a covariate, and no groups.}

\item{p}{A non-negative integer specifying the autoregressive (AR) order of the ARMA structure. 
Default is 0.}

\item{q}{A non-negative integer specifying the moving average (MA) order of the ARMA structure. 
Default is 0.}

\item{r}{A non-negative integer specifying the autoregressive response (ARR) order. 
See 'Details' for differences of AR and ARR effects. Default is 0.}

\item{cov}{A flag indicating whether ARMA effects should be estimated by means
of residual covariance matrices
(currently only possible for stationary ARMA effects of order 1). 
If \code{FALSE} (the default) a regression formulation
is used that is considerably faster and allows for ARMA effects 
of order higher than 1 but cannot handle user defined standard errors.}
}
\value{
An object of class \code{cor_arma}, representing an 
  autoregression-moving-average correlation structure.
}
\description{
This functions is a constructor for the \code{cor_arma} class, representing 
an autoregression-moving average correlation structure of order (p, q).
}
\details{
As of \pkg{brms} version 0.6.0, the AR structure refers to autoregressive effects of residuals
  to match the naming and implementation in other packages such as nlme. 
  Previously, the AR term in \pkg{brms} referred to autoregressive effects of the response.
  The latter are now named ARR effects and can be modeled using argument \code{r} in the
  \code{cor_arma} and \code{cor_arr} functions.
}
\examples{
cor_arma(~visit|patient, p = 2, q = 2)

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
\seealso{
\code{\link[brms:cor_ar]{cor_ar}} \code{\link[brms:cor_ma]{cor_ma}}
  \code{\link[brms:cor_arr]{cor_arr}}
}

