% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.generics.R
\name{posterior.samples}
\alias{posterior.samples}
\alias{posterior.samples.brmsfit}
\title{Extract posterior samples}
\usage{
posterior.samples(x, parameters = NA, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{parameters}{Name of parameters for which posterior samples should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted}

\item{...}{Currently ignored}
}
\value{
A data frame containing the posterior samples, with one column per parameter.
}
\description{
Extract posterior samples of specified parameters
}
\details{
Currently there are methods for \code{brmsfit} objects.
}
\examples{
\dontrun{
fit_i <- brm(rating ~ treat + period + carry + (1|subject), data = inhaler, family = "cumulative")

#extract posterior samples of fixed effects
samples1 <- posterior.samples(fit_i, "b_")
head(samples1)

#extract posterior samples of standard deviations of random effects
samples2 <- posterior.samples(fit_i, "sd_")
head(samples2)
}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

