# Generated by roxytest: do not edit by hand!

# File R/"04-show.R": @testexamples

test_that("Function br_show_forest() @ L51", {
  
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  br_show_forest(m)
  br_show_forest(m, clean = TRUE, drop = 3)
  br_show_forest(m, clean = FALSE)
  assert_s3_class(br_show_forest(m), "forestplot")
})


test_that("Function br_show_forest_ggstats() @ L301", {
  
  if (rlang::is_installed("ggstats")) {
    m <- br_pipeline(mtcars,
      y = "mpg",
      x = colnames(mtcars)[2:4],
      x2 = "vs",
      method = "gaussian"
    )
    br_show_forest_ggstats(m)
  }
  
  expect_true(TRUE)
})


test_that("Function br_show_forest_ggstatsplot() @ L344", {
  
  if (rlang::is_installed("ggstats")) {
    m <- br_pipeline(mtcars,
      y = "mpg",
      x = colnames(mtcars)[2:4],
      x2 = "vs",
      method = "gaussian"
    )
    br_show_forest_ggstatsplot(m)
  }
  
  expect_true(TRUE)
})


test_that("Function br_show_fitted_line() @ L384", {
  
  if (rlang::is_installed("visreg")) {
    m <- br_pipeline(mtcars,
      y = "mpg",
      x = colnames(mtcars)[2:4],
      x2 = "vs",
      method = "gaussian"
    )
  
    if (interactive()) {
      br_show_fitted_line(m)
    }
    br_show_fitted_line(m, xvar = "cyl")
  }
  
  expect_true(TRUE)
})


test_that("Function br_show_fitted_line_2d() @ L423", {
  
  if (rlang::is_installed("visreg")) {
    m <- br_pipeline(mtcars,
      y = "mpg",
      x = colnames(mtcars)[2:4],
      x2 = "vs",
      method = "gaussian"
    )
  
    br_show_fitted_line_2d(m, xvar = "cyl", yvar = "mpg")
  }
  
  expect_true(TRUE)
})


test_that("Function br_show_coxph_diagnostics() @ L478", {
  
  # Create Cox models
  mds <- br_pipeline(
    survival::lung,
    y = c("time", "status"),
    x = colnames(survival::lung)[6:10],
    x2 = c("age", "sex"),
    method = "coxph"
  )
  
  # Show Cox diagnostic plots
  p1 <- br_show_coxph_diagnostics(mds, idx = 1)
  p1
  p2 <- br_show_coxph_diagnostics(mds, type = "martingale")
  p2
  
  expect_s3_class(p1, "alignpatches")
  expect_s3_class(p2, "ggplot")
})


test_that("Function br_show_table() @ L914", {
  
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  
  br_show_table(m)
  br_show_table(m, export = TRUE)
  if (interactive()) {
    br_show_table(m, export = TRUE, args_table_export = list(format = "html"))
  }
  expect_true(TRUE)
})


test_that("Function br_show_table_gt() @ L952", {
  
  if (rlang::is_installed("gtsummary")) {
    m <- br_pipeline(mtcars,
      y = "mpg",
      x = colnames(mtcars)[2:4],
      x2 = "vs",
      method = "gaussian"
    )
    br_show_table_gt(m)
  }
  
  expect_true(TRUE)
})


test_that("Function br_show_residuals() @ L1193", {
  
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  
  # Single model residual plot
  br_show_residuals(m, idx = 1)
  
  # Multiple models
  br_show_residuals(m, idx = c(1, 2))
  
  # All models
  br_show_residuals(m)
  
  expect_s3_class(br_show_residuals(m, idx = 1), "ggplot")
})


test_that("Function br_show_nomogram() @ L1377", {
  
  
  # Cox regression nomogram
  
  lung <- survival::lung |> dplyr::filter(ph.ecog != 3)
  lung$ph.ecog <- factor(lung$ph.ecog)
  mds <- br_pipeline(
    lung,
    y = c("time", "status"),
    x = c("age", "ph.ecog"),
    x2 = "sex",
    method = "coxph"
  )
  p <- br_show_nomogram(mds)
  p
  
  
  # Linear regression nomogram
  mds_lm <- br_pipeline(
    mtcars,
    y = "mpg",
    x = c("hp", "wt"),
    x2 = "vs",
    method = "gaussian"
  )
  p2 <- br_show_nomogram(mds_lm, fun_at = c(15, 20, 25, 30))
  p2
  
  expect_s3_class(p, "ggplot")
  expect_s3_class(p2, "ggplot")
})


test_that("Function br_show_forest_circle() @ L1461", {
  
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  br_show_forest_circle(m)
  br_show_forest_circle(m, style = "bars")
  br_show_forest_circle(m, sort_by = "estimate")
  br_show_forest_circle(m, ref_line = FALSE)
  br_show_forest_circle(m, ref_line = 0.5)
  assert_s3_class(br_show_forest_circle(m), "ggplot")
})

