% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix_coef_diff_by_group_stan.R
\name{as.matrix.coef_diff_by_group_stan}
\alias{as.matrix.coef_diff_by_group_stan}
\title{S3 as.matrix for result of coef_diff_by_group}
\usage{
\method{as.matrix}{coef_diff_by_group_stan}(x, ...)
}
\arguments{
\item{x}{Result of a call to \code{coef_diff_by_group(fit)}}

\item{...}{parameter name as string, e.g. \code{"m", "k", "beta", "t50_bluck_coward"}.
When missing, \code{"t50_maes_ghoos"} is assumed.}
}
\value{
mcmc array with columns of differences for use with functions from packages
bayesplot or coda
}
\description{
Generates a matrix that can be used with plotting functions from
package \code{\link[bayesplot]{mcmc_hist}}.
}
\examples{
\donttest{
library(dplyr)
library(breathtestcore)
library(ggplot2)
data("usz_13c", package = "breathtestcore")
data = usz_13c \%>\%
  dplyr::filter( patient_id \%in\%  c("norm_001", "norm_002", "norm_003",
                        "norm_004", "pat_001", "pat_002","pat_003")) \%>\%
  cleanup_data()
fit = stan_group_fit(data, iter = 300, chains = 1)
cf = coef_diff_by_group(fit)
str(cf)
# Calling without parameters gives Maes/Ghoos t50
bayesplot::mcmc_hist(as.matrix(cf))
# Use a function from the bayesplot universe
dens = bayesplot::mcmc_dens(as.matrix(cf, parameter = "m"))
# use suppressMessages to avoid a message "another scale"
suppressMessages(
  dens + geom_vline(xintercept = 0) + scale_x_continuous(limits= c(-20,10)))
}
}
