% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_iris_csv.R
\name{read_iris_csv}
\alias{read_iris_csv}
\title{Read 13C data from IRIS/Wagner Analysen in CSV Format}
\usage{
read_iris_csv(filename = NULL, text = NULL)
}
\arguments{
\item{filename}{Name of IRIS/Wagner file in CSV format}

\item{text}{alternatively, text can be given as string}
}
\value{
List of class \code{breath_test_data} with \code{file name, 
patient name, patient first name, test, identifikation},
and data frame \code{data} with \code{time} and \code{dob}
}
\description{
Reads 13C data from IRIS/Wagner Analysen in CSV Format
The CSV files start as follows:
\preformatted{
"Name","Vorname","Test","Identifikation"
} 
This format does not have information about the substrate (acetate, octanoate),
the dose and body weight and height. The following defaults are used: \code{substrate = acetate, 
dose = 100,  weight = 75, height = 180}.
}
\examples{
filename = btcore_file("IrisCSV.TXT")
cat(readLines(filename, n = 3), sep="\n")
#
iris_data = read_iris_csv(filename)
str(iris_data)
}
