% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawnuOR2}
\alias{drawnuOR2}
\title{Samples scale factor \eqn{\nu} for OR2 model}
\usage{
drawnuOR2(z, x, beta, sigma, tau2, theta, lambda)
}
\arguments{
\item{z}{Gibbs draw of continuous latent values, a column vector.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{sigma}{\eqn{\sigma}, a scalar value.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{lambda}{index parameter of GIG distribution which is equal to 0.5.}
}
\value{
column vector of \eqn{\nu} from a GIG distribution.
}
\description{
This function samples \eqn{\nu} from a generalized inverse Gaussian (GIG)
distribution for OR2 model (ordinal quantile model with exactly 3 outcomes).
}
\details{
This function samples \eqn{\nu} from a GIG
distribution.
}
\examples{
set.seed(101)
z <- c(21.01744, 33.54702, 33.09195, -3.677646,
 21.06553, 1.490476, 0.9618205, -6.743081, 21.02186, 0.6950479)
x <- matrix(c(
     1, -0.3010490, 0.8012506,
     1,  1.2764036, 0.4658184,
     1,  0.6595495, 1.7563655,
     1, -1.5024607, -0.8251381,
     1, -0.9733585, 0.2980610,
     1, -0.2869895, -1.0130274,
     1,  0.3101613, -1.6260663,
     1, -0.7736152, -1.4987616,
     1, 0.9961420, 1.2965952,
     1, -1.1372480, 1.7537353),
     nrow = 10, ncol = 3, byrow = TRUE)
beta <- c(-0.74441, 1.364846, 0.7159231)
sigma <- 3.749524
tau2 <- 10.6667
theta <- 2.6667
lambda <- 0.5
output <- drawnuOR2(z, x, beta, sigma, tau2, theta, lambda)

# output
#   5.177456 4.042261 8.950365
#   1.578122 6.968687 1.031987
#   4.13306 0.4681557 5.109653
#   0.1725333

}
\references{
Rahman, M. A. (2016), “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1), 1-24. DOI: 10.1214/15-BA939

Devroye, L. (2014). “Random variate generation for the generalized inverse Gaussian
distribution.” Statistics and Computing, 24(2): 239–246. DOI: 10.1007/s11222-012-9367-z
}
\seealso{
GIGrvg, Gibbs sampling, \link[GIGrvg]{rgig}
}
