% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc.R
\name{bpc}
\alias{bpc}
\title{Bayesian Paired comparison  regression models in Stan}
\usage{
bpc(
  data,
  player0,
  player1,
  player0_score = NULL,
  player1_score = NULL,
  result_column = NULL,
  z_player1 = NULL,
  cluster = NULL,
  predictors = NULL,
  model_type,
  solve_ties = "random",
  win_score = "higher",
  priors = NULL,
  chains = 4,
  iter = 2000,
  warmup = 1000,
  show_chain_messages = TRUE,
  seed = NA
)
}
\arguments{
\item{data}{A data frame containing the observations. The other parameters specify the name of the columns}

\item{player0}{A string with name of the column containing the players 0. This column should be of string/character type and not be of factor type.}

\item{player1}{A string with name of the column containing the players 0. This column should be of string/character type and not be of factor type.}

\item{player0_score}{A string with name of the column containing the scores of players 0}

\item{player1_score}{A string with name of the column containing the scores of players 1}

\item{result_column}{A string with name of the column containing the winners. 0 for player 0, 1 for player 1 and 2 for ties}

\item{z_player1}{A string with the name of the column containing the order effect for player 1. E.g. if player1 has the home advantage this column should have 1 otherwise it should have 0}

\item{cluster}{A string with the name of the column containing the cluster for the observation. To be used with a random effects model. This column should contain strings}

\item{predictors}{A data frame that contains the players predictors values when using a generalized model. Only numeric values are accepted. Booleans are accepted but will be cast into integers. The first column should be for the player name, the others will be the predictors.  The column names will be used as name for the predictors}

\item{model_type}{We first add a base model 'bt' or 'davidson' and then additional options with '-'
\itemize{
\item 'bt' for the Bradley Terry model. Ref: Bradley-Terry 1952,
\item 'davidson' the Davidson model to handle for ties. Ref: Davidson 1970
\item 'bt-ordereffect' for the Bradley-Terry with order effect, for home advantage. Ref: Davidson 1977
\item 'davidson-ordereffect' for the Davidson model with order effect, for home advantage, and ties. Ref: Davidson 1977
\item 'bt-generalized': for the generalized Bradley Terry model for subject specific predictors. Ref: Springall 1973
\item 'davidson-generalized' for the generalized Davidson model for subject specific predictors
\item 'bt-U': for the Bradley-Terry with random effects. Ref: Bockenholt 2001
\item 'davidson-U': For Davidson model with random effects
\item 'bt-ordereffect-U' for Bradley-Terry with order effects and random effects, use similar syntax for other variations by appending the correct options
}}

\item{solve_ties}{A string for the method of handling ties.
\itemize{
\item 'random' for converting ties randomly,
\item 'remove' for removing the tie occurrences
\item 'none' to ignore ties. This requires a model capable of handling  ties
}}

\item{win_score}{A string that indicates if which score should win
\itemize{
\item 'higher' score is winner
\item 'lower' score is winner
}}

\item{priors}{A list with the parameters for the priors.
\itemize{
\item 'prior_lambda_mu' Mean value of the lambda parameter in the all models. For the generalized this is also the prior for the B the parameter for  lambda ~ normal(mu, std)
\item 'prior_lambda_std' Standard deviation of the lambda parameter in the all models. lambda ~ normal(mu, std)
\item 'prior_nu_mu' Mean value of the nu parameter in the Davidson  models. nu ~ normal(mu, std)
\item 'prior_nu_std' Standard deviation ofnu parameter in the Davidson  models. nu ~ normal(mu, std). Default = 0.3
\item 'prior_gm_mu' Mean value of the gm in the ordered effect model. gm ~ normal(mu, std). Default = 0
\item 'prior_gm_std' Standard deviation of the gm parameter in the ordered effect model. gm ~ normal(mu, std). Default =
\item 'prior_U_std' Standard deviation of the U parameter in the random effects model. U ~ normal(0, std). Default = 3.0
}}

\item{chains}{Number of chains passed to Stan sampling. Positive integer, default=4. For more information consult Stan documentation}

\item{iter}{Number of iterations passed to Stan sampling. Positive integer, default =2000. For more information consult Stan documentation}

\item{warmup}{Number of iteration for the warmup passed to Stan sampling. Positive integer, default 1000.  For more information consult Stan documentation}

\item{show_chain_messages}{Hide chain messages from Stan}

\item{seed}{a random seed for Stan}
}
\value{
An object of the class bpc. This object should be used in conjunction with the several auxiliary functions from the package
}
\description{
This is the main function of the package.
This function utilizes precompiled stan models to sample the posterior distribution of the specified model with the input data.
For more information and larger examples of usage see the vignettes.
}
\examples{
\donttest{
#For the simple Bradley-Terry model
bpc(data = tennis_agresti,
player0 = 'player0',
player1 = 'player1',
result_column = 'y',
model_type = 'bt',
solve_ties = 'none')
}
}
\references{
\enumerate{
\item Bradley RA, Terry ME 1952. Rank Analysis of Incomplete Block Designs I: The Method of Paired Comparisons. Biometrika, 39, 324 45.
\item Davidson RR 1970. On Extending the Bradley-Terry Model to Accommodate Ties in Paired Comparison Experiments. Journal of the American Statistical Association, 65, 317 328.
\item Davidson, Roger R., and Robert J. Beaver 1977. "n extending the Bradley-Terry model to incorporate within-pair order effects. Biometrics: 693 702.
\item Stan Development Team 2020. RStan: the R interface to Stan. R package version 2.21.2.
\item Bockenholt, Ulf. Hierarchical modeling of paired comparison data. Psychological Methods 6.1 2001: 49.
\item Springall, A. Response Surface Fitting Using a Generalization of the Bradley-Terry Paired Comparison Model. Journal of the Royal Statistical Society: Series C Applied Statistics 22.1 1973: 59 68.
}
}
