% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unload.r
\name{unload}
\alias{unload}
\alias{reload}
\title{Unload or reload a given module}
\usage{
unload(mod)

reload(mod)
}
\arguments{
\item{mod}{the module reference to be unloaded or reloaded}
}
\value{
\code{box::unload} and \code{box::reload} are called for their
side-effect. They do not return anything.
}
\description{
Unload a given module or reload it from its source.
}
\details{
Unloading a module causes it to be purged from the internal cache such that
the next subsequent \code{box::use} declaration will reload the module from
its source. \code{reload} is a shortcut for unloading a module and calling
\code{box::use} in the same scope with the same parameters as the
\code{box::use} call that originally loaded the current module instance.
}
\note{
Any other references to the loaded modules remain unchanged, and will
still work. Unloading and reloading modules is primarily useful for testing
during development, and should not be used in production code.

\code{unload} and \code{reload} come with a few restrictions. \code{unload}
attempts to detach names attached by the corresponding \code{box::use} call.
\code{reload} attempts to re-attach these same names. This only works if the
corresponding \code{box::use} declaration is located in the same scope.

\code{reload} will re-execute the \code{.on_load} hook of the module.
}
\seealso{
\code{\link{use}}, \link{mod-hooks}
}
