% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_unused_attached_mod_linter.R
\name{box_unused_attached_mod_linter}
\alias{box_unused_attached_mod_linter}
\title{\code{box} library unused attached module linter}
\usage{
box_unused_attached_mod_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}.
}
\description{
Checks that all attached modules are used within the source file. This also covers modules
attached using the \code{...}.
}
\details{
For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
\dontrun{
# will produce lints
code <- "
box::use(
  path/to/module
)
"

lintr::lint(code, linters = box_unused_attached_mod_linter())

code <- "
box::use(
  alias = path/to/module
)
"

lintr::lint(code, linters = box_unused_attached_mod_linter())

code <- "
box::use(
  path/to/module[...]
)
"

lintr::lint(code, linters = box_unused_attached_mod_linter())

# okay
code <- "
box::use(
  path/to/module
)

module$some_function()
"

lintr::lint(code, linters = box_unused_attached_mod_linter())

code <- "
box::use(
  alias = path/to/module
)

alias$some_function()
"

lintr::lint(code, linters = box_unused_attached_mod_linter())

code <- "
box::use(
  path/to/module[...]     # module exports some_function()
)

some_function()
"

lintr::lint(code, linters = box_unused_attached_mod_linter())
}

}
