% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis.R
\name{kinesis_get_shard_iterator}
\alias{kinesis_get_shard_iterator}
\title{Gets an Amazon Kinesis shard iterator}
\usage{
kinesis_get_shard_iterator(stream, shard,
  shard_iterator_type = c("TRIM_HORIZON", "LATEST", "AT_SEQUENCE_NUMBER",
  "AFTER_SEQUENCE_NUMBER", "AT_TIMESTAMP"), ...)
}
\arguments{
\item{stream}{the name of the stream to describe}

\item{shard}{the shard ID of the Kinesis Data Streams shard to get the iterator for}

\item{shard_iterator_type}{determines how the shard iterator is used to start reading data records from the shard}

\item{...}{optional further parameters, such as \code{StartingSequenceNumber} or \code{Timestamp}}
}
\value{
list of \code{ShardIterator}
}
\description{
Gets an Amazon Kinesis shard iterator
}
\references{
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/kinesis.html#Kinesis.Client.get_shard_iterator}
}
\seealso{
\code{\link{kinesis_get_records}}
}
