% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deck_funcs.R
\name{shuffle_deck}
\alias{shuffle_deck}
\title{Shuffle a Deck of Cards}
\usage{
shuffle_deck(deck_of_cards = deck, seed)
}
\arguments{
\item{deck_of_cards}{A dataframe representing the deck of cards or a function
that generates values for the deck. Defaults to a predefined deck named \code{deck}.}

\item{seed}{An optional seed for reproducibility.}
}
\value{
A shuffled dataframe of cards. The dataframe will have a class attribute
of "data.frame", "shuffled deck", and either "deck", "anonymous deck"
or "interleaved deck" depending on the input.
}
\description{
This function shuffles a given deck of cards. If the provided deck is a function,
it generates values based on the anonymous function before shuffling.
If not, it directly shuffles the provided deck.
}
\examples{
# Using a predefined deck
shuffled <- shuffle_deck(seed = 123)

# Using an anonymous function
fun_deck <- function(x) { stats::runif(52, 1, 52) }
shuffled <- shuffle_deck(deck_of_cards = fun_deck, seed = 123)

# Using an anonymous function to create an interleaved deck
shuffled <- shuffle_deck(deck_of_cards = function(x) {list(stats::rnorm(26, 1, 2),
                                                           stats::rnorm(26, 1.5, 1.5))},
                         seed = 100)

}
