\name{boot.array}
\alias{boot.array}
\title{
Bootstrap Resampling Arrays
}
\description{
This function takes a bootstrap object calculated by one of the functions
\code{boot}, \code{censboot}, or \code{tilt.boot} and returns the frequency (or index)
array for the the bootstrap resamples.
}
\usage{
boot.array(boot.out, indices=<<see below>>)
}
\arguments{
\item{boot.out}{
An object of class \code{"boot"} returned by one of the generation functions for
such an object.
}
\item{indices}{
A logical argument which specifies whether to return the frequency array
or the raw index array.  The default is \code{indices=F} unless \code{boot.out} was 
created by \code{tsboot} in which case the default is \code{indices=T}.
}}
\value{
A matrix with \code{boot.out$R} rows and \code{n} columns where \code{n} is the number of
observations in \code{boot.out$data}.  If \code{indices} is \code{FALSE} then this will give
the frequency of each of the original observations in each bootstrap resample.
If \code{indices} is \code{TRUE} it will give the indices of the bootstrap resamples in
the order in which they would have been passed to the statistic.  
}
\section{Side Effects}{
This function temporarily resets \code{.Random.seed} to the value in \code{boot.out$seed}
and then returns it to its original value at the end of the function.
}
\details{
The process by which the original index array was generated is repeated with
the same value of \code{.Random.seed}.  If the frequency array is required then 
\code{freq.array} is called to convert the index array to a frequency array. 


A resampling array can only be returned when such a concept makes sense.  In 
particular it cannot be found for any parametric or model-based resampling
schemes.  Hence for objects generated by \code{censboot} the only resampling
scheme for which such an array can be found is ordinary case resampling.  
Similarly if \code{boot.out$sim} is \code{"parametric"} in the case of \code{boot}
or \code{"model"} in the case of \code{tsboot} the array cannot be found.  Note also
that for post-blackened bootstraps from \code{tsboot} the indices found will relate
to those prior to any post-blackening and so will not be useful.


Frequency arrays are used in many post-bootstrap calculations such as
the jackknife-after-bootstrap and finding importance sampling weights.
They are also used to find empirical influence values through the
regression method.
}
\seealso{
\code{\link{boot}}, \code{\link{censboot}}, \code{\link{freq.array}}, \code{\link{tilt.boot}}, \code{\link{tsboot}}
}
\examples{
#  A frequency array for a nonparametric bootstrap
data(city)
city.boot <- boot(city, corr, R=40, stype="w")
boot.array(city.boot)


perm.cor <- function(d,i) 
     cor(d$x,d$u[i])
city.perm <- boot(city, perm.cor, R=40, sim="permutation")
boot.array(city.perm, indices=T)
}
\keyword{nonparametric}
% Converted by Sd2Rd version 1.15.
