% Generated by roxygen2 (4.0.0): do not edit by hand
\name{makePredictions}
\alias{makePredictions}
\title{Gather predictions from an ensemble of estimators.}
\usage{
makePredictions(estimators, newdata, .parallel = FALSE)
}
\arguments{
\item{estimators}{a list of functions which take a single (mandatory)
argument and returns class label.}

\item{newdata}{the data to feed to each estimator in \code{estimators}}

\item{.parallel}{a boolean indicating if the predictions should happen in
parallel through \code{estimators}. Defaulted to \code{FALSE}.}
}
\value{
a matrix of predicted responses (either numeric or character, if predictions
are factor variables). The columns corresponds to rows in \code{newdata} so
that class-prediction aggregation can be done more effeciently.
}
\description{
A parallelized for-loop that goes through each estimator in the given
ensemble and collects its predictions in for each row of the given data.
}

