% Generated by roxygen2 (4.0.0): do not edit by hand
\name{adaboostAggregator}
\alias{adaboostAggregator}
\title{Aggregator for the Adaboost.M1 algorithm}
\usage{
adaboostAggregator(estimators, alpha, ..., .parallelPredict = FALSE)
}
\arguments{
\item{estimators}{a list of estimators which must produce output in the same
response-space. This is usually the output of some reweighter function.}

\item{...}{this does nothing -- meant to swallow auxillary output from
reweighter function.}

\item{.parallelPredict}{a boolean indicating if prediction should be carried
out in parallel.}

\item{alpha}{a vector (or list) of length equal to the length of
\code{estimators}. Each entry of \code{alpha} acts as a prediction weight for
the corresponding estimator.}
}
\value{
a function whose sole argument is \code{newdata} and whose output
is the aggregated predictions of the boosted ensemble, \code{estimators}.

For internal bookkeeping, this function is inherits from the
'\code{aggregator}' class.
}
\description{
Implements a (parallelized) version of the aggregator described
in the Adaboost.M1 algorithm.
}
\seealso{
Other adaboost: \code{\link{adaboostReweighter}}

Other aggregators: \code{\link{arcfsAggregator}};
  \code{\link{arcx4Aggregator}},
  \code{\link{vanillaAggregator}},
  \code{\link{weightedAggregator}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}}
}

