% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/BN-methods.R
\docType{class}
\name{BN-class}
\alias{BN}
\alias{BN,BN-class}
\alias{BN-class}
\alias{initialize,BN-method}
\title{BN class definition.}
\usage{
\S4method{initialize}{BN}(.Object, dataset = NULL, ...)

BN(dataset = NULL, ...)
}
\arguments{
\item{.Object}{a BN}

\item{dataset}{a \code{\link{BNDataset}} object containing the dataset the network is built upon, if any. The remaining parameters
are considered only if a starting dataset is provided.}

\item{...}{potential further arguments of methods.}
}
\value{
BN object.
}
\description{
BN class definition.

Instantiate a \code{\link{BN}} object.
}
\details{
The constructor may be invoked without parameters -- in this case an empty network will be created, and its slots will be filled manually by the user.
This is usually viable only if the user already has knowledge about the network structure.
}
\section{Slots}{

\describe{
  \item{\code{name}:}{name of the network}
  \item{\code{num.nodes}:}{number of nodes in the network}
  \item{\code{variables}:}{names of the variables in the network}
  \item{\code{discreteness}:}{\code{TRUE} if variable is discrete, \code{FALSE} if variable is continue}
  \item{\code{node.sizes}:}{if variable \code{i} is discrete, \code{node.sizes[i]} contains the cardinality of \code{i},
     if \code{i} is instead discrete the value is the number of states variable \code{i} takes when discretized}
  \item{\code{cpts}:}{list of conditional probability tables of the network}
  \item{\code{dag}:}{adjacency matrix of the network}
  \item{\code{wpdag}:}{weighted partially dag}
  \item{\code{scoring.func}:}{scoring function used in structure learning (when performed)}
  \item{\code{struct.algo}:}{algorithm used in structure learning (when performed)}
  \item{\code{num.time.steps}:}{number of instants in which the network is observed (1, unless it is a Dynamic Bayesian Network)}
}
}
\examples{
\dontrun{
net.1 <- BN()

dataset <- BNDataset()
dataset <- read.dataset(dataset, "file.header", "file.data")
net.2 <- BN(dataset)
}


}

