% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.algorithms.R
\name{check.algorithms}
\alias{check.algorithms}
\title{Verifies the BN learning algorithms}
\usage{
check.algorithms(bn.learn.algorithms)
}
\arguments{
\item{bn.learn.algorithms}{is a list of algorithms (present in bnlearn) to be used in BN structure learning pocess.}
}
\value{
NULL.
}
\description{
This function verifies if a list of BN learning algorithms passed has allowed algorithms.
}
\details{
This function receives a list of algorithms and verifies if they are allowed to learn the BN structure.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# Set what BN learning algorithms will be used
bn.learn.algorithms <- c("hc", "mmhc")
# Check these algorithms
check.algorithms(bn.learn.algorithms)
# Changing for not allowed algorithms
bn.learn.algorithms <- c("tabu-search", "mhc")
# Check these algorithms
check.algorithms(bn.learn.algorithms)
}
\author{
Elias Carvalho
}

