% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgestrength.R
\name{edge_strength}
\alias{edge_strength}
\title{Strength of edges in a Bayesian network}
\usage{
edge_strength(bnfit)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}
}
\value{
A dataframe with first two columns the edge list of the \code{bn.fit} input object. The third column \code{Edge.Strength} reports the measure of edge strength.
}
\description{
Computation of the measure of edge strength for all edges in a Bayesian networks
}
\details{
The measure of edge strength is defined as the largest diameter out of all conditional probability tables where all other parents but the considered one are fixed to a specific combination.
}
\examples{
edge_strength(travel)

}
\references{
Leonelli, M., Smith, J. Q., & Wright, S. K. (2024). The diameter of a stochastic matrix: A new measure for sensitivity analysis in Bayesian networks. arXiv preprint arXiv:2407.04667.
}
\seealso{
\code{\link{diameter}}
}
