% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_parameter_estimates}
\alias{get_parameter_estimates}
\title{Obtains parameter estimates from MCMC samples}
\usage{
get_parameter_estimates(samps, level = 95)
}
\arguments{
\item{samps}{A matrix of N by p samples for the p parameters}

\item{level}{Desired confidence level - defaults to 95\%.}
}
\value{
A data frame containing four columns: mean, sd, low (er limit), 
and up (per limit) for the p parameters.
}
\description{
Obtains parameter estimates from MCMC samples
}
\examples{
samps <- matrix(rnorm(10000), ncol= 10 )
dim(samps)
a <- get_parameter_estimates(samps)
a
b <- get_parameter_estimates(samps, level=98)
b
}
