% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-gains-table.R
\name{blr_ks_chart}
\alias{blr_ks_chart}
\title{KS chart}
\usage{
blr_ks_chart(gains_table, title = "KS Chart", yaxis_title = " ",
  xaxis_title = "Cumulative Population \%", ks_line_color = "black")
}
\arguments{
\item{gains_table}{An object of class \code{blr_gains_table}.}

\item{title}{Plot title.}

\item{yaxis_title}{Y axis title.}

\item{xaxis_title}{X axis title.}

\item{ks_line_color}{Color of the line indicating maximum KS statistic.}
}
\description{
Kolmogorov-Smirnov (KS) statistics is used to assess predictive power for
marketing or credit risk models. It is the maximum difference between %
cumulative event and non-event distribution across score/probability bands.
The gains table typically has % cumulative event and % cumulative non-event
across score bands and can be used to find the KS for a model.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))
gt <- blr_gains_table(model)
blr_ks_chart(gt)

}
\references{
Tjur, T. (2009), "Coefficients of Determination in Logistic Regression Models — A New Proposal:
The Coefficient of Discrimination," The American Statistician, 63(4), 366-372.

Horn, S. D. (1977), Goodness-of-fit tests for discrete data: a review and an application to a
health impairment scale, Biometrics, 33, 237–247.
}
\seealso{
Other model validation techniques: \code{\link{blr_confusion_matrix}},
  \code{\link{blr_decile_capture_rate}},
  \code{\link{blr_decile_lift_chart}},
  \code{\link{blr_gains_table}},
  \code{\link{blr_gini_index}},
  \code{\link{blr_lorenz_curve}},
  \code{\link{blr_roc_curve}},
  \code{\link{blr_test_hosmer_lemeshow}}
}
