% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{adjusted_alpha}
\alias{adjusted_alpha}
\title{Adjusted level of significance}
\usage{
adjusted_alpha(design, n1, nuisance, ...)
}
\arguments{
\item{design}{object of class \code{TestStatistic} created by \code{setup}}

\item{n1}{total number of patients that are recruited before the sample size
is recalculated}

\item{nuisance}{nuisance parameter that is estimated at the interim analysis}

\item{...}{Further optional arguments.}
}
\value{
Value of the adjusted significance level
 for every nuisance parameter and every value of n1.
}
\description{
This method returns an adjusted significance level that can be used
such that the actual type I error rate is preserved.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.

The method is implemented for the classes \code{\link{Student}},
\code{\link{ChiSquare}}, and \code{\link{FarringtonManning}}.
Check the class-specific documentation for further parameters that have
to be specified.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 0, delta_NI = 1.5, n_max = 848)
sigma <- c(2, 5.5, 9)
adjusted_alpha(design = d, n1 = 20, nuisance = sigma, tol = 1e-4, iters = 1e3)

}
