% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquare.R
\name{n_fix,ChiSquare-method}
\alias{n_fix,ChiSquare-method}
\title{Fixed Sample Size}
\usage{
\S4method{n_fix}{ChiSquare}(
  design,
  nuisance,
  variance = c("heterogeneous", "homogeneous"),
  rounded = TRUE,
  ...
)
}
\arguments{
\item{design}{Object of class \code{ChiSquare} created by \code{setupChiSquare}.}

\item{nuisance}{Value of the nuisance parameter. For the
Chi-Squared test this is the overall response rate.}

\item{variance}{A character string indicating whether the "\code{heterogenous}" (default)
or the "\code{homogeneous}" variance formula should be used.}

\item{rounded}{Whether the calculated sample size should be rounded up such that
the allocation ratio is preserved.}

\item{...}{Further optional arguments.}
}
\value{
One value of the fixed sample size for every nuisance parameter
 and every value of n1.
}
\description{
Returns the sample size of a fixed design without sample size recalculation.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
  design1 <- setupChiSquare(alpha = 0.025, beta = 0.2, r = 1, delta = 0.2)
  n_fix(design1, nuisance = c(0.2, 0.3))

}
