% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blatentPPMC.R
\name{blatentPPMC}
\alias{blatentPPMC}
\title{blatentPPMC}
\usage{
blatentPPMC(
  model,
  nSamples,
  seed = model$options$seed,
  parallel = TRUE,
  nCores = 4,
  type = c("mean", "covariance", "univariate", "bivariate", "tetrachoric", "pearson"),
  lowPPMCpercentile = c(0.025, 0.025, 0, 0, 0.025, 0.025),
  highPPMCpercentile = c(0.975, 0.975, 1, 1, 0.975, 0.975)
)
}
\arguments{
\item{model}{A blatent MCMC model object.}

\item{nSamples}{The number of PPMC samples to be simulated.}

\item{seed}{The random number seed. Defaults to the seed set in the blatent model object.}

\item{parallel}{If parallelization should be used in PPMC. Defaults to \code{"TRUE"}.}

\item{nCores}{If \code{"parallel == TRUE"}, then specifies the number of cores to use. Defaults to four.}

\item{type}{The type of statistic to generate, submitted as a character vector. Options include:
\itemize{
   \item \code{"mean"} computes and tabulates the mean for the posterior simulated data for each
   observed variable.
   \item \code{"covariance"} computes and tabulates the covariance for the posterior simulated data
   for all pairs of observed variables.
   \item \code{"univariate"} computes and tabulates a Pearson Chi-Square comparing the counts for
   an observed variable with the counts for a variable from the posterior simulated data, for each observed variable.
   \item \code{"bivariate"}computes and tabulates a Pearson Chi-Square comparing the counts for a
    pair of observed variables with the counts for a pair of variables from the posterior simulated
    data, for each pair of observed variables.
   \item \code{"tetrachoric"} computes and tabulates the tetrachoric correlation for the
   posterior simulated data for all pairs of observed variables.
   \item \code{"pearson"} computes and tabulates the Pearson correlation for the
   posterior simulated data for all pairs of observed variables.
   }}

\item{lowPPMCpercentile}{A vector of the lower bound percentiles used for flagging statistics against PPMC
predictive distributions. Results are flagged if the observed statistics percentile is lower than
the number in the vector. Provided in order of each term in \code{"type"}. Defaults to
\code{"c(.025, .025, 0, 0, .025, .025)"}.}

\item{highPPMCpercentile}{A vector of the upper bound percentiles used for flagging statistics against PPMC
predictive distributions. Results are flagged if the observed statistics percentile is higher than
the number in the vector. Provided in order of each term in \code{"type"}. Defaults to
\code{"c(.975, .975, 1, 1, .975, .975)"}.}
}
\description{
Simulates data using parameters from posterior distribution of blatent Markov chain.
}
