% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{summary.biplot}
\alias{summary.biplot}
\title{Generic summary function for objects of class biplot}
\usage{
\method{summary}{biplot}(
  object,
  adequacy = TRUE,
  axis.predictivity = TRUE,
  sample.predictivity = TRUE,
  class.predictivity = TRUE,
  within.class.axis.predictivity = TRUE,
  within.class.sample.predictivity = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{biplot}.}

\item{adequacy}{a logical value indicating whether variable adequacies should be reported, with default \code{TRUE}.}

\item{axis.predictivity}{a logical value indicating whether axis predictivities should be reported, with default \code{TRUE}.}

\item{sample.predictivity}{a logical value indicating whether sample predictivities should be reported, with default \code{TRUE}.}

\item{class.predictivity}{a logical value indicating whether class predictivities should be reported, with default \code{TRUE}
(only applicable to objects of class \code{CVA}).}

\item{within.class.axis.predictivity}{a logical value indicating whether within class axis predictivity
should be reported, with default \code{TRUE} (only applicable to objects
of class \code{CVA}).}

\item{within.class.sample.predictivity}{a logical value indicating whether within class sample predictivity
should be reported, with default \code{TRUE} (only applicable to objects
of class \code{CVA}).}

\item{...}{additional arguments.}
}
\value{
This function will not produce a return value, it is called for side effects.
}
\description{
This function is used to print summary output of the biplot. These summary outputs are related to measures of fit.
}
\examples{
out <- biplot (iris[,1:4]) |> PCA() |> fit.measures()
summary(out)

}
