% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_helpers.R
\name{closest_to_centroid}
\alias{closest_to_centroid}
\title{Detection of the closest points to the centroid of a cloud of points}
\usage{
closest_to_centroid(data, x_column, y_column, space, n = 1, id_column = NULL)
}
\arguments{
\item{data}{matrix or data.frame that contains at least two columns.}

\item{x_column}{(character) the name of the x-axis.}

\item{y_column}{(character) the name of the y-axis.}

\item{space}{(character) space in which the thinning will be performed.
There are two options available: "G", if it will be in geographic space, and
"E", if it will be in environmental space.}

\item{n}{(numeric) number of points that are close to the centroid to be
detected. Default = 1.}

\item{id_column}{(character or numeric) name or numeric index of the column
in \code{data} containing identifiers of one or distinct sets of points.
If, NULL, the default, only one set is assumed.}
}
\value{
A data.frame containing \code{n} rows corresponding to the point or points
that are the closest to the centroid of all other points of reference.
}
\description{
Detection of the closest points to the centroid of a cloud of points
}
\examples{
# Data
data("m_matrix", package = "biosurvey")
data1 <- m_matrix$data_matrix

# Finding the closest point to the centroid
centroid <- closest_to_centroid(data1, x_column = "Longitude",
                                y_column = "Latitude", space = "G",
                                n = 1, id_column = NULL)
}
