% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PseudoAbsences.R
\name{bm_PseudoAbsences}
\alias{bm_PseudoAbsences}
\alias{bm_PseudoAbsences_random}
\alias{bm_PseudoAbsences_sre}
\alias{bm_PseudoAbsences_disk}
\alias{bm_PseudoAbsences_user.defined}
\alias{bm_PseudoAbsences_user.defined,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_user.defined,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_random,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_random,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_sre,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_sre,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_disk,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_disk,ANY,SpatRaster-method}
\title{Select pseudo-absences}
\usage{
bm_PseudoAbsences(
  resp.var,
  expl.var,
  nb.rep = 1,
  strategy = "random",
  dist.min = 0,
  dist.max = NULL,
  nb.absences = NULL,
  sre.quant = 0,
  user.table = NULL
)

bm_PseudoAbsences_user.defined(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_user.defined}{ANY,SpatVector}(resp.var, expl.var, user.table)

\S4method{bm_PseudoAbsences_user.defined}{ANY,SpatRaster}(resp.var, expl.var, user.table)

bm_PseudoAbsences_random(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_random}{ANY,SpatVector}(resp.var, expl.var, nb.absences, nb.rep)

\S4method{bm_PseudoAbsences_random}{ANY,SpatRaster}(resp.var, expl.var, nb.absences, nb.rep)

bm_PseudoAbsences_sre(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_sre}{ANY,SpatVector}(resp.var, expl.var, sre.quant, nb.absences, nb.rep)

\S4method{bm_PseudoAbsences_sre}{ANY,SpatRaster}(resp.var, expl.var, sre.quant, nb.absences, nb.rep)

bm_PseudoAbsences_disk(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_disk}{ANY,SpatVector}(
  resp.var,
  expl.var,
  dist.min,
  dist.max,
  nb.absences,
  nb.rep
)

\S4method{bm_PseudoAbsences_disk}{ANY,SpatRaster}(
  resp.var,
  expl.var,
  dist.min,
  dist.max,
  nb.absences,
  nb.rep
)
}
\arguments{
\item{resp.var}{a \code{vector}, \code{\link[sp]{SpatialPoints}} or 
\code{\link[sp]{SpatialPointsDataFrame}} object containing binary data (\code{0} : absence, 
\code{1} : presence, \code{NA} : indeterminate) for a single species that will be used to 
find the pseudo-absences}

\item{expl.var}{a \code{matrix}, \code{data.frame}, \code{\link[sp]{SpatialPointsDataFrame}} 
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables (in 
columns or layers) that will be used to find the pseudo-absences}

\item{nb.rep}{an \code{integer} corresponding to the number of sets (repetitions) of 
pseudo-absence points that will be drawn}

\item{strategy}{a \code{character} corresponding to the pseudo-absence selection strategy, 
must be among \code{random}, \code{sre}, \code{disk} or \code{user.defined}}

\item{dist.min}{(\emph{optional, default} \code{0}) \cr
If \code{strategy = 'disk'}, a \code{numeric} defining the minimal distance to presence points 
used to make the \code{disk} pseudo-absence selection (in meters)}

\item{dist.max}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'disk'}, a \code{numeric} defining the maximal distance to presence points 
used to make the \code{disk} pseudo-absence selection (in meters)}

\item{nb.absences}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'random'} or \code{strategy = 'sre'} or \code{strategy = 'disk'}, an 
\code{integer} corresponding to the number of pseudo-absence points that will be selected for 
each pseudo-absence repetition (true absences included)}

\item{sre.quant}{(\emph{optional, default} \code{0}) \cr
If \code{strategy = 'sre'}, a \code{numeric} between \code{0} and \code{0.5} defining the 
half-quantile used to make the \code{sre} pseudo-absence selection (see \code{\link{bm_SRE}})}

\item{user.table}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'user.defined'}, a \code{matrix} or \code{data.frame} with as many rows as 
\code{resp.var} values, as many columns as \code{nb.rep}, and containing \code{TRUE} or 
\code{FALSE} values defining which points will be used to build the species distribution 
model(s) for each repetition}

\item{\ldots}{(\emph{optional, one or several of the following arguments depending on the selected 
method)})}
}
\value{
A \code{list} containing the following elements :
\itemize{
  \item{\code{xy} : }{the coordinates of the species observations}
  \item{\code{sp} : }{the values of the species observations (\code{0}, \code{1} or \code{NA})}
  \item{\code{env} : }{the explanatory variables}
  \item{\code{pa.tab} : }{the corresponding table of selected pseudo-absences (indicated by 
  \code{TRUE} or \code{FALSE})}
}
}
\description{
This internal \pkg{biomod2} function allows to select pseudo-absences according 
to 4 different methods : \code{random}, \code{sre}, \code{disk} or \code{user.defined} (see Details).
}
\details{
\bold{Concerning random selection :}

The idea is to select pseudo-absences randomly in spatial locations where the species has not 
been sampled. This method is the simplest one and the most appropriate if lacking information 
about the presence sampling (non-exhaustive, biased sampling, etc). \cr \cr

\bold{Concerning SRE selection :}

The idea is to select pseudo-absences in spatial locations whose environmental conditions are 
different from those of the presence points. This method is appropriate when most of the 
environmental space of the species has been sampled. \cr \cr

\bold{Concerning disk selection :}

The idea is to select pseudo-absences, not too close from presence points, but not too far 
away either. This method is appropriate when most of the spatial range of the species has 
been sampled. \cr \cr

\bold{Concerning user defined selection :}

The user can provide pseudo-absences locations through a table containing spatial locations 
in rows, pseudo-absences repetitions in columns, and \code{TRUE/FALSE} values indicating 
whether each point is to be considered as pseudo-absence or not for each dataset.
}
\seealso{
\code{\link{BIOMOD.formated.data.PA}}, \code{\link{BIOMOD_FormatingData}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Wilfried Thuiller, Damien Georges
}
\concept{Secundary functions}
\keyword{SRE}
\keyword{disk}
\keyword{pseudo-absence}
\keyword{random}
