% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.factor.levels.R
\name{sample.factor.levels}
\alias{sample.factor.levels}
\title{Tool to ensure the sampling of all levels of a factorial variable}
\usage{
sample.factor.levels(x, mask.out = NULL, mask.in = NULL)
}
\arguments{
\item{x}{a Raster* object or a data.frame}

\item{mask.out}{a Raster/data.frame mask containing area that have already 
been sampled. The factor levels within this mask will not be sampled.}

\item{mask.in}{a Raster/list of Raster/data.frame mask (potentially a stack of 
masks) indicating areas were we want to sample our factor level in priority.
Note that if after having explore this masks some levels of the considered
factorial varialble remains unsampled, this levels will be sampled in the 
reference input object (here 'x')}
}
\value{
a numeric vector the number (cell number for Raster* objects or row 
  number for data.frame) where each will refer to a single level of a single
  factorial variable.
}
\description{
This function will sample randomly an element of each level
  of all the factorial variables contains in a Raster* object or a data.frame
}
\details{
In case any factorial variable is found in the input object then 
  NULL is returned.
}
\note{
- The x/mask.out/mask.in should be coherent in term of dimention (same number of 
    rows for data.frame and same number of rows, column, identic resolution 
    and projection coordinates system for Raster* objects)
  - If mask.in contains several masks (RasterStack or multi-column data.frame)
    then the order of the mask matter. The mask will be considered successively.
    The first will be use prioritarly to sample our variable factor levels and 
    so on.
  - Raster* masks will be understood as: 
      - NA: out of of mask
      - not NA: in mask
  - data.frame masks will be understood as:
      - FALSE: out of mask
      - TRUE: in mask
}
\examples{
## example with raster* object ---------- 
## create a factorial raster
r1 <- raster()
r1[] <- 1; r1[1] <- 2; r1[2:3] <- 3
r1 <- as.factor(r1)
## create a continuous raster
r2 <- raster()
r2[] <- rnorm(ncell(r2))
## pull the raster into a RasterStack
stk <- stack(r1, r2)
is.factor(stk)

## define a mask for already sampled points
mask.out <- r1
mask.out[] <- NA; mask.out[2:3] <- 1

## define a list of mask where we want to sample in priority
mask.in.1 <- mask.in.2 <- r1
mask.in.1[1:10] <- NA ## only level 1 should be sampled in this mask
mask.in.2[1] <- NA ## only levels 1 and 3 should be sampled in this mask
mask.in <- list(mask.in.1 = mask.in.1, 
                mask.in.2 = mask.in.2)

## test different version of the function
sample.factor.levels(stk, mask.out = mask.out)
sample.factor.levels(stk, mask.in = mask.in)
sample.factor.levels(stk, mask.out = mask.out, mask.in = mask.in)

}
\author{
damien g.
}

