% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{biokNN.impute.mi}
\alias{biokNN.impute.mi}
\title{Multiple imputation for a multilevel dataset}
\usage{
biokNN.impute.mi(
  data,
  className,
  m = 5,
  nIter = 10,
  weight = 0.5,
  k = 10,
  distance = "gower"
)
}
\arguments{
\item{data}{A dataframe with missing values}

\item{className}{name of the variable that contains the classes}

\item{m}{number of imputations}

\item{nIter}{number of iterations, default = 10}

\item{weight}{weight of the kNN values in the objective function, default = 0.5}

\item{k}{number of nearest neighbours, default = 10}

\item{distance}{distance function used to get the k-nearest neighbors}
}
\value{
A dataframe with the imputed data
}
\description{
This function returns a list of m complete datasets, where the missing values are imputed
using a bi-objective kNN method. It assumes that the class variable name is known, and the rest
of the variables are numerical.
}
\examples{
data(data.example)
complete.data.mi <- biokNN.impute.mi(data.example,
               className = "class",
               m = 3,
               nIter = 10,
               weight = 0.9,
               k = 15,
               distance = "gower")
# View completed data sets
str(complete.data.mi)
}
