% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_models.R
\name{WeibullPeleg_iso}
\alias{WeibullPeleg_iso}
\title{Isothermal Weibull-Peleg Model}
\usage{
WeibullPeleg_iso(time, temp, n, k_b, temp_crit)
}
\arguments{
\item{time}{numeric indicating the time at which the prediction is taken.}

\item{temp}{numeric indicating the temperature of the treatment.}

\item{n}{numeric defining shape factor of the Weibull distribution.}

\item{k_b}{numeric indicating the slope of the b~temp line.}

\item{temp_crit}{numeric with the value of the critical temperature.}
}
\value{
A numeric with the predicted logarithmic reduction
(\eqn{log10(N/N0)}).
}
\description{
Returns the predicted logarithmic reduction in microbial count according
to Weibull-Peleg's model for the time, temperature and model parameters
given.
}
